(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     17929,        609]*)
(*NotebookOutlinePosition[     44276,       1566]*)
(*  CellTagsIndexPosition[     44018,       1554]*)
(*WindowFrame->Palette*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  "Welcome to the\n",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 3.0 \nTrial Version"
}], "Subsection",
  PageWidth->220],

Cell[TextData[{
  "The Trial Version is a full-function ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " system, licensed to run for a limited time, and with saving disabled."
}], "SmallText",
  PageWidth->220],

Cell[TextData[{
  "To obtain a permanent license for ",
  StyleBox["Mathematica,",
    FontSlant->"Italic"],
  " with saving enabled, simply contact ",
  StyleBox[ButtonBox["Wolfram Research",
    ButtonData:>"Company Addresses",
    ButtonStyle->"OtherInformationLink",
    ButtonNote->None],
    FontSize->10,
    FontWeight->"Plain",
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True}],
  " or an authorized ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " reseller."
}], "SmallText",
  PageWidth->220],

Cell[TextData[{
  "This navigation palette will help you get started with ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 3.0."
}], "SmallText",
  PageWidth->220],

Cell[TextData[{
  "Click the appropriate \[RightTriangle] icon to open each section below. \
Then click the subject buttons to link to topics in the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " Help Browser."
}], "SmallText",
  PageWidth->220]
}, Open  ]],

Cell[CellGroupData[{

Cell["Starting Out", "Section"],

Cell[BoxData[GridBox[{
        {
          ButtonBox[\(Starting\ Mathematica\),
            ButtonData:>"Starting Mathematica (Macintosh)"]},
        {
          ButtonBox[\(Your\ First\ Calculations\),
            ButtonData:>"Your First Calculations (Macintosh)"]},
        {
          ButtonBox[\(The  Help  Browser\),
            ButtonData:>"The Help Browser (Macintosh)"]},
        {
          ButtonBox[\(Using  Palettes\),
            ButtonData:>"Using Palettes (Macintosh)"]},
        {
          ButtonBox[\(Entering  Mathematical  Notation\),
            ButtonData:>"Entering Mathematical Notation (Macintosh)"]},
        {
          ButtonBox[\(Notebooks  and  Cells\),
            ButtonData:>"Notebooks and Cells (Macintosh)"]},
        {
          ButtonBox[\(Animations  and  Sound\),
            ButtonData:>"Animations and Sound (Macintosh)"]},
        {
          ButtonBox[\(Creating  Palettes\),
            ButtonData:>"Creating Palettes (Macintosh)"]},
        {
          ButtonBox["Hyperlinks",
            ButtonData:>"Hyperlinks (Macintosh)"]},
        {
          ButtonBox[\(Features  of  Notebooks\),
            ButtonData:>"Features of Notebooks (Macintosh)"]}
        },
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], "ButtonBG",
  ButtonBoxOptions->{ButtonStyle->"GettingStartedLink"}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Tour of\n",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  " "
}], "Section"],

Cell[BoxData[GridBox[{
        {
          ButtonBox[
            RowBox[{
              StyleBox["Mathematica",
                FontSlant->"Italic"], \(\ as\ a\ Calculator\)}],
            ButtonData:>"T.1"]},
        {
          ButtonBox[
            RowBox[{\(Power\ Computing\ with\ \), 
              StyleBox["Mathematica",
                FontSlant->"Italic"]}],
            ButtonData:>"T.2"]},
        {
          ButtonBox[
            RowBox[{\(Accessing\ Algorithms\ in\ \), 
              StyleBox["Mathematica",
                FontSlant->"Italic"]}],
            ButtonData:>"T.3"]},
        {
          ButtonBox[
            RowBox[{\(Mathematical\ Knowledge\ in\ \), 
              StyleBox["Mathematica",
                FontSlant->"Italic"]}],
            ButtonData:>"T.4"]},
        {
          ButtonBox[\(Building\ Up\ Computations\),
            ButtonData:>"T.5"]},
        {
          ButtonBox[\(Handling\ Data\),
            ButtonData:>"T.6"]},
        {
          ButtonBox[
            RowBox[{\(Visualization\ with\ \), 
              StyleBox["Mathematica",
                FontSlant->"Italic"]}],
            ButtonData:>"T.7"]},
        {
          ButtonBox[
            RowBox[{
              StyleBox["Mathematica",
                FontSlant->"Italic"], \(\ Notebooks\)}],
            ButtonData:>"T.8"]},
        {
          ButtonBox[\(Palettes\ and\ Buttons\),
            ButtonData:>"T.9"]},
        {
          ButtonBox[\(Mathematical\ Notation\),
            ButtonData:>"T.10"]},
        {
          ButtonBox[
            RowBox[{
              StyleBox["Mathematica",
                FontSlant->"Italic"], \(and\ Your\ Computing\ Environment\)}],
            
            ButtonData:>"T.11"]},
        {
          ButtonBox[
            RowBox[{\(The\ Unifying\ Idea\ of\ \), 
              StyleBox["Mathematica",
                FontSlant->"Italic"]}],
            ButtonData:>"T.12"]},
        {
          ButtonBox[\(Mathematica\ as\ a\ Programming\ Language\),
            ButtonData:>"T.13"]},
        {
          ButtonBox[
            RowBox[{\(Writing\ Programs\ in\ \), 
              StyleBox["Mathematica",
                FontSlant->"Italic"]}],
            ButtonData:>"T.14"]},
        {
          ButtonBox[
            RowBox[{\(Building\ Systems\ with\ \), 
              StyleBox["Mathematica",
                FontSlant->"Italic"]}],
            ButtonData:>"T.15"]},
        {
          ButtonBox[
            RowBox[{
              StyleBox["Mathematica",
                FontSlant->"Italic"], \(\ as\ a\ Software\ Component\)}],
            ButtonData:>"T.16"]},
        {
          ButtonBox[
            RowBox[{\(The\ World\ of\ \), 
              StyleBox["Mathematica",
                FontSlant->"Italic"]}],
            ButtonData:>"T.17"]}
        },
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], "ButtonBG",
  ButtonBoxOptions->{ButtonStyle->"GettingStartedLink"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Demos", "Section"],

Cell[BoxData[GridBox[{
        {
          ButtonBox[\(Buckyball\ Construction\),
            ButtonData:>"Buckyball Construction"]},
        {
          ButtonBox[\(Calculating\ Pi\),
            ButtonData:>"Calculating Pi"]},
        {
          ButtonBox[\(Calendar\ Maker\),
            ButtonData:>"Calendar Maker"]},
        {
          ButtonBox[\(Catalan\ Formulas\),
            ButtonData:>"Catalan Formulas"]},
        {
          ButtonBox[\(Celestial\ Mechanics\ Sampler\),
            ButtonData:>"Celestial Mechanics Sampler"]},
        {
          ButtonBox[\(Cellular\ Automata\),
            ButtonData:>"Cellular Automata"]},
        {
          ButtonBox[\(Chaotic\ Circuit\),
            ButtonData:>"Chaotic Circuit"]},
        {
          ButtonBox[\(Computer\ Art\),
            ButtonData:>"Computer Art"]},
        {
          ButtonBox[\(Cover\ Image\ Construction\),
            ButtonData:>"Cover Image Construction"]},
        {
          ButtonBox[\(Formatting\ Sampler\),
            ButtonData:>"Formatting Sampler"]},
        {
          ButtonBox[\(Inequality\ Proof\),
            ButtonData:>"Inequality Proof"]},
        {
          ButtonBox[\(Integrals, \ Sums\ and\ Products\),
            ButtonData:>"Integrals, Sums and Products"]},
        {
          ButtonBox[\(Klein\ Bottle\ Formula\),
            ButtonData:>"Klein Bottle Formula"]},
        {
          ButtonBox[\(Landau - Ramanujan\n
            \ Constant\),
            ButtonData:>"Landau-Ramanujan Constant"]},
        {
          ButtonBox[\(Multipole\ Fields\),
            ButtonData:>"Multipole Fields"]},
        {
          ButtonBox[\(Notation\ Maker\),
            ButtonData:>"Notation Maker"]},
        {
          ButtonBox[\(Notebook\ Manipulation\),
            ButtonData:>"Notebook Manipulation"]},
        {
          ButtonBox[\(Numerics\ Report\),
            ButtonData:>"Numerics Report"]},
        {
          ButtonBox[\(Programming\ Sampler\),
            ButtonData:>"Programming Sampler"]},
        {
          ButtonBox[\(Special\ Characters\),
            ButtonData:>"Special Characters"]},
        {
          ButtonBox["Spirograph",
            ButtonData:>"Spirograph"]},
        {
          ButtonBox[\(Step - by - Step\n
            \ Differentiation\),
            ButtonData:>"Step-by-Step Differentiation"]},
        {
          ButtonBox[\(Weierstrass\ Surfaces\),
            ButtonData:>"Weierstrass Surfaces"]}
        },
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], "ButtonBG",
  ButtonBoxOptions->{ButtonStyle->"GettingStartedLink"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Galleries", "Section"],

Cell[CellGroupData[{

Cell["Formula Gallery", "Subsubsection",
  CellTags->"formula"],

Cell[BoxData[GridBox[{
        {
          ButtonBox[\(Definite\ Integral\),
            ButtonData:>"G.1.1"]},
        {
          ButtonBox[\(Pisot\ Number\),
            ButtonData:>"G.1.2"]},
        {
          ButtonBox[\(Antisymmetric\ Tensors\),
            ButtonData:>"G.1.3"]},
        {
          ButtonBox[\(Trigonometric\ Formulas\),
            ButtonData:>"G.1.4"]},
        {
          ButtonBox[\(Some\ Definite\ Integrals\),
            ButtonData:>"G.1.5"]},
        {
          ButtonBox["Partitions",
            ButtonData:>"G.1.6"]},
        {
          ButtonBox[\(Ellipsoid\ Surface\ Area\),
            ButtonData:>"G.1.7"]},
        {
          ButtonBox[\(Iterated\ Radical\ Identities\),
            ButtonData:>"G.1.8"]},
        {
          ButtonBox[\(Polylogarithm\ Identities\),
            ButtonData:>"G.1.9"]},
        {
          ButtonBox[\(Heisenberg - Euler\ Lagrangian\),
            ButtonData:>"G.1.10"]},
        {
          ButtonBox[\(Homological\ Algebra\),
            ButtonData:>"G.1.11"]},
        {
          ButtonBox[\(Zeta\ Function\ Sums\),
            ButtonData:>"G.1.12"]},
        {
          ButtonBox[\(Green' s\ Function\),
            ButtonData:>"G.1.13"]},
        {
          ButtonBox[\(Matrix\ Square\ Root\),
            ButtonData:>"G.1.14"]},
        {
          ButtonBox[\(Indefinite\ Integrals\),
            ButtonData:>"G.1.15"]}
        },
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], "ButtonBG",
  ButtonBoxOptions->{ButtonStyle->"MainBookLink"}]
}, Closed]],

Cell[CellGroupData[{

Cell["2D Graphics", "Subsubsection",
  CellTags->"2DGraphics"],

Cell[BoxData[GridBox[{
        {
          ButtonBox[\(Brillouin\ Zones\),
            ButtonData:>"G.2.1"]},
        {
          ButtonBox[\(Checkerboard\ Inversion\),
            ButtonData:>"G.2.2"]},
        {
          ButtonBox[\(Circle\ Inversions\),
            ButtonData:>"G.2.3"]},
        {
          ButtonBox[\(Iterated\ Curve\ Reflections\),
            ButtonData:>"G.2.4"]},
        {
          ButtonBox[\(Koch\ Curve\),
            ButtonData:>"G.2.5"]},
        {
          ButtonBox[\(L\ System\ Curve\),
            ButtonData:>"G.2.6"]},
        {
          ButtonBox[\(Nested\ Disks\),
            ButtonData:>"G.2.7"]},
        {
          ButtonBox[\(Phyllotaxis\ Spiral\),
            ButtonData:>"G.2.8"]},
        {
          ButtonBox[\(Random\ Arc\ Tree\),
            ButtonData:>"G.2.9"]},
        {
          ButtonBox[\(Sine\ Wave\ Superposition\),
            ButtonData:>"G.2.10"]},
        {
          ButtonBox[\(Smooth\ Random\ Areas\),
            ButtonData:>"G.2.11"]},
        {
          ButtonBox[\(Voderberg\ Spiral\),
            ButtonData:>"G.2.12"]}
        },
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], "ButtonBG",
  ButtonBoxOptions->{ButtonStyle->"MainBookLink"}]
}, Closed]],

Cell[CellGroupData[{

Cell["3D Graphics", "Subsubsection",
  CellTags->"3DGraphics"],

Cell[BoxData[GridBox[{
        {
          ButtonBox[\(Connected\ Cylinders\),
            ButtonData:>"G.2.13"]},
        {
          ButtonBox[\(Klein\ Bottle\),
            ButtonData:>"G.2.14"]},
        {
          ButtonBox["Polyhedra",
            ButtonData:>"G.2.15"]},
        {
          ButtonBox[\(Polyhedral\ Octopus\),
            ButtonData:>"G.2.16"]},
        {
          ButtonBox[\(Random\ Interpolation\),
            ButtonData:>"G.2.17"]},
        {
          ButtonBox[\(Random\ Rotations\),
            ButtonData:>"G.2.18"]},
        {
          ButtonBox[\(Riemann\ Surface\ 1\),
            ButtonData:>"G.2.19"]},
        {
          ButtonBox[\(Riemann\ Surface\ 2\),
            ButtonData:>"G.2.20"]},
        {
          ButtonBox[\(Space\ Curve\ Contraction\),
            ButtonData:>"G.2.21"]},
        {
          ButtonBox[\(Zeta\ Function\),
            ButtonData:>"G.2.22"]}
        },
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], "ButtonBG",
  ButtonBoxOptions->{ButtonStyle->"MainBookLink"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Diagrams and Objects", "Subsubsection",
  CellTags->"Diagrams"],

Cell[BoxData[GridBox[{
        {
          ButtonBox[\(Archimedean\ Spiral\),
            ButtonData:>"G.2.23"]},
        {
          ButtonBox["Beethoven",
            ButtonData:>"G.2.24"]},
        {
          ButtonBox["Bookshelf",
            ButtonData:>"G.2.25"]},
        {
          ButtonBox[\(GaAs\ Crystal\),
            ButtonData:>"G.2.26"]},
        {
          ButtonBox[\(McPherson\ Strut\),
            ButtonData:>"G.2.27"]},
        {
          ButtonBox[\(Origami\ Bird\),
            ButtonData:>"G.2.28"]},
        {
          ButtonBox["Planisphere",
            ButtonData:>"G.2.29"]},
        {
          ButtonBox[\(Solar\ Eclipse\ Chart\),
            ButtonData:>"G.2.30"]},
        {
          ButtonBox[\(Telescope\ Optics\),
            ButtonData:>"G.2.31"]}
        },
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], "ButtonBG",
  ButtonBoxOptions->{ButtonStyle->"MainBookLink"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Art Images", "Subsubsection",
  CellTags->"ArtImages"],

Cell[BoxData[GridBox[{
        {
          ButtonBox[\(Composition\ 1\),
            ButtonData:>"G.2.32"]},
        {
          ButtonBox[\(Composition\ 2\),
            ButtonData:>"G.2.33"]},
        {
          ButtonBox[\(Composition\ 3\),
            ButtonData:>"G.2.34"]},
        {
          ButtonBox[\(Composition\ 4\),
            ButtonData:>"G.2.35"]}
        },
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], "ButtonBG",
  ButtonBoxOptions->{ButtonStyle->"MainBookLink"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Animations", "Subsubsection",
  CellTags->"Animations"],

Cell[BoxData[GridBox[{
        {
          ButtonBox[\(Rolling\ Square\),
            ButtonData:>"G.2.36"]},
        {
          ButtonBox["Origami",
            ButtonData:>"G.2.37"]},
        {
          ButtonBox[\(Cam - Follower\ Mechanism\),
            ButtonData:>"G.2.38"]},
        {
          ButtonBox[\(Arch\ Motion\),
            ButtonData:>"G.2.39"]},
        {
          ButtonBox[\(Gear\ Mechanism\),
            ButtonData:>"G.2.40"]},
        {
          ButtonBox[\(Interlocking\ Tori\),
            ButtonData:>"G.2.41"]}
        },
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], "ButtonBG",
  ButtonBoxOptions->{ButtonStyle->"MainBookLink"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Color Charts", "Subsubsection",
  CellTags->"ColorCharts"],

Cell[BoxData[GridBox[{
        {
          ButtonBox["GrayLevel",
            ButtonData:>"G.2.42"]},
        {
          ButtonBox["Hue",
            ButtonData:>"G.2.43"]},
        {
          ButtonBox["RGBColor",
            ButtonData:>"G.2.44"]},
        {
          ButtonBox["CMYKColor",
            ButtonData:>"G.2.45"]},
        {
          ButtonBox[\(Light\ Source\ Variations\),
            ButtonData:>"G.2.46"]},
        {
          ButtonBox[\(Surface\ Color\ Variations\),
            ButtonData:>"G.2.47"]}
        },
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], "ButtonBG",
  ButtonBoxOptions->{ButtonStyle->"MainBookLink"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Palette Demos", "Subsubsection"],

Cell[BoxData[
    ButtonBox[
      AdjustmentBox[\(Palette\ Demos\),
        BoxMargins->{{4.2, 4.2}, {0, 0.5}}],
      ButtonData:>"Palette Demos"]], "ButtonBG",
  ButtonBoxOptions->{ButtonStyle->"GettingStartedLink"}]
}, Closed]]
}, Closed]]
},
FrontEndVersion->"NeXT 3.0",
ScreenRectangle->{{0, 1053}, {0, 832}},
Editable->False,
WindowToolbars->{},
CellGrouping->Manual,
WindowSize->{250, 300},
WindowMargins->{{23, Automatic}, {Automatic, 14}},
WindowFrame->"Palette",
WindowElements->"VerticalScrollBar",
WindowFrameElements->"CloseBox",
WindowClickSelect->False,
WindowTitle->"Trial Version Navigator",
Active->True,
StyleDefinitions -> Notebook[{
  
  Cell[CellGroupData[{
  Cell["Style Definitions", "Subtitle"],
  
  Cell["\<\
Modify the definitions below to change the default appearance of \
all cells in a given style.  Make modifications to any definition using \
commands in the Format menu.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell["Style Environment Names", "Section"],
  
  Cell[StyleData[All, "Working"],
    PageWidth->WindowWidth,
    ScriptMinSize->9],
  
  Cell[StyleData[All, "Presentation"],
    PageWidth->WindowWidth,
    ScriptMinSize->12,
    FontSize->16],
  
  Cell[StyleData[All, "Condensed"],
    PageWidth->WindowWidth,
    CellBracketOptions->{"Margins"->{1, 1},
    "Widths"->{0, 5}},
    ScriptMinSize->8,
    FontSize->11],
  
  Cell[StyleData[All, "Printout"],
    PageWidth->PaperWidth,
    ScriptMinSize->5,
    FontSize->10,
    PrivateFontOptions->{"FontType"->"Outline"}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Notebook Options", "Section"],
  
  Cell["\<\
The options defined for the style below will be used at the \
Notebook level.\
\>", "Text"],
  
  Cell[StyleData["Notebook"],
    PageHeaders->{{Cell[ 
            TextData[ {
              CounterBox[ "Page"]}], "PageNumber"], None, Cell[ 
            TextData[ {
              ValueBox[ "FileName"]}], "Header"]}, {Cell[ 
            TextData[ {
              ValueBox[ "FileName"]}], "Header"], None, Cell[ 
            TextData[ {
              CounterBox[ "Page"]}], "PageNumber"]}},
    CellFrameLabelMargins->6,
    StyleMenuListing->None]
  }, Open  ]],
  
  Cell[CellGroupData[{
  
  Cell["Styles for Headings", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Title"],
    CellMargins->{{12, Inherited}, {20, 40}},
    CellGroupingRules->{"TitleGrouping", 0},
    PageBreakBelow->False,
    CounterIncrements->"Title",
    CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
        "Subtitle", 0}, {"Subsubtitle", 0}},
    FontFamily->"Helvetica",
    FontSize->36,
    FontWeight->"Bold"],
  
  Cell[StyleData["Title", "Presentation"],
    CellMargins->{{24, 10}, {20, 40}},
    LineSpacing->{1, 0},
    FontSize->44],
  
  Cell[StyleData["Title", "Condensed"],
    CellMargins->{{8, 10}, {4, 8}},
    FontSize->20],
  
  Cell[StyleData["Title", "Printout"],
    CellMargins->{{2, 10}, {15, 30}},
    FontSize->24]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subtitle"],
    CellMargins->{{12, Inherited}, {10, 15}},
    CellGroupingRules->{"TitleGrouping", 10},
    PageBreakBelow->False,
    CounterIncrements->"Subtitle",
    CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
        "Subsubtitle", 0}},
    FontFamily->"Helvetica",
    FontSize->24],
  
  Cell[StyleData["Subtitle", "Presentation"],
    CellMargins->{{24, 10}, {15, 20}},
    LineSpacing->{1, 0},
    FontSize->36],
  
  Cell[StyleData["Subtitle", "Condensed"],
    CellMargins->{{8, 10}, {4, 4}},
    FontSize->14],
  
  Cell[StyleData["Subtitle", "Printout"],
    CellMargins->{{2, 10}, {10, 15}},
    FontSize->18]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subsubtitle"],
    CellMargins->{{12, Inherited}, {10, 20}},
    CellGroupingRules->{"TitleGrouping", 20},
    PageBreakBelow->False,
    CounterIncrements->"Subsubtitle",
    CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
    FontFamily->"Helvetica",
    FontSize->14,
    FontSlant->"Italic"],
  
  Cell[StyleData["Subsubtitle", "Presentation"],
    CellMargins->{{24, 10}, {10, 20}},
    LineSpacing->{1, 0},
    FontSize->24],
  
  Cell[StyleData["Subsubtitle", "Condensed"],
    CellMargins->{{8, 10}, {8, 12}},
    FontSize->12],
  
  Cell[StyleData["Subsubtitle", "Printout"],
    CellMargins->{{2, 10}, {8, 10}},
    FontSize->14]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Section"],
    PageWidth->400,
    CellFrame->{{0, 0}, {0, 0.25}},
    CellDingbat->None,
    ShowCellBracket->False,
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{30, 183}, {3, 20}},
    CellGroupingRules->{"SectionGrouping", 30},
    PageBreakBelow->False,
    CellFrameMargins->{{0, 0}, {4, 4}},
    CounterIncrements->"Section",
    CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
    FontFamily->"Helvetica",
    FontSize->18,
    FontWeight->"Bold",
    FontColor->RGBColor[0.529488, 0.03859, 0.555657]],
  
  Cell[StyleData["Section", "Presentation"],
    CellMargins->{{40, 10}, {11, 32}},
    LineSpacing->{1, 0},
    FontSize->24],
  
  Cell[StyleData["Section", "Condensed"],
    CellMargins->{{18, Inherited}, {6, 12}},
    FontSize->12],
  
  Cell[StyleData["Section", "Printout"],
    CellMargins->{{13, 0}, {7, 22}},
    FontSize->14]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subsection"],
    PageWidth->250,
    CellDingbat->None,
    ShowCellBracket->False,
    CellMargins->{{0, 0}, {8, 0}},
    CellGroupingRules->{"SectionGrouping", 40},
    PageBreakBelow->False,
    ParagraphIndent->30,
    CounterIncrements->"Subsection",
    CounterAssignments->{{"Subsubsection", 0}},
    FontFamily->"Helvetica",
    FontSize->18,
    FontWeight->"Bold",
    Background->RGBColor[0.76054, 0.59588, 0.853391]],
  
  Cell[StyleData["Subsection", "Presentation"],
    CellMargins->{{36, 10}, {11, 32}},
    LineSpacing->{1, 0},
    FontSize->22],
  
  Cell[StyleData["Subsection", "Condensed"],
    CellMargins->{{16, Inherited}, {6, 12}},
    FontSize->12],
  
  Cell[StyleData["Subsection", "Printout"],
    CellMargins->{{9, 0}, {7, 22}},
    FontSize->12]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subsubsection"],
    PageWidth->400,
    CellFrame->False,
    ShowCellBracket->False,
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{30, 185}, {5, 15}},
    CellGroupingRules->{"SectionGrouping", 50},
    PageBreakBelow->False,
    CellFrameMargins->{{3, 0}, {0, 0}},
    AutoIndent->False,
    CounterIncrements->"Subsubsection",
    FontWeight->"Bold",
    FontColor->GrayLevel[1],
    Background->GrayLevel[0]],
  
  Cell[StyleData["Subsubsection", "Presentation"],
    CellMargins->{{34, 10}, {11, 26}},
    LineSpacing->{1, 0},
    FontSize->18],
  
  Cell[StyleData["Subsubsection", "Condensed"],
    CellMargins->{{17, Inherited}, {6, 12}},
    FontSize->10],
  
  Cell[StyleData["Subsubsection", "Printout"],
    CellMargins->{{9, 0}, {7, 14}},
    FontSize->11]
  }, Closed]]
  }, Open  ]],
  
  Cell[CellGroupData[{
  
  Cell["Styles for Body Text", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Text"],
    CellMargins->{{12, 10}, {7, 7}},
    LineSpacing->{1, 3},
    CounterIncrements->"Text"],
  
  Cell[StyleData["Text", "Presentation"],
    CellMargins->{{24, 10}, {10, 10}},
    LineSpacing->{1, 5}],
  
  Cell[StyleData["Text", "Condensed"],
    CellMargins->{{8, 10}, {6, 6}},
    LineSpacing->{1, 1}],
  
  Cell[StyleData["Text", "Printout"],
    CellMargins->{{2, 2}, {6, 6}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SmallText"],
    PageWidth->370,
    ShowCellBracket->False,
    CellMargins->{{30, 0}, {6, 0}},
    LineSpacing->{1, 3},
    CounterIncrements->"SmallText",
    FontFamily->"Helvetica",
    FontSize->10],
  
  Cell[StyleData["SmallText", "Presentation"],
    CellMargins->{{24, 10}, {8, 8}},
    LineSpacing->{1, 5},
    FontSize->12],
  
  Cell[StyleData["SmallText", "Condensed"],
    CellMargins->{{8, 10}, {5, 5}},
    LineSpacing->{1, 2},
    FontSize->9],
  
  Cell[StyleData["SmallText", "Printout"],
    CellMargins->{{2, 2}, {5, 5}},
    FontSize->7]
  }, Closed]]
  }, Open  ]],
  
  Cell[CellGroupData[{
  
  Cell["Styles for Input/Output", "Section"],
  
  Cell["\<\
The cells in this section define styles used for input and output \
to the kernel.  Be careful when modifying, renaming, or removing these \
styles, because the front end associates special meanings with these style \
names.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Input"],
    CellMargins->{{45, 10}, {5, 7}},
    Evaluatable->True,
    CellGroupingRules->"InputGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultInputFormatType,
    AutoItalicWords->{},
    FormatType->InputForm,
    ShowStringCharacters->True,
    NumberMarks->True,
    CounterIncrements->"Input",
    FontWeight->"Bold"],
  
  Cell[StyleData["Input", "Presentation"],
    CellMargins->{{72, Inherited}, {8, 10}},
    LineSpacing->{1, 0}],
  
  Cell[StyleData["Input", "Condensed"],
    CellMargins->{{40, 10}, {2, 3}}],
  
  Cell[StyleData["Input", "Printout"],
    CellMargins->{{39, 0}, {4, 6}},
    FontSize->9]
  }, Closed]],
  
  Cell[StyleData["InputOnly"],
    Evaluatable->True,
    CellGroupingRules->"InputGrouping",
    CellHorizontalScrolling->True,
    DefaultFormatType->DefaultInputFormatType,
    AutoItalicWords->{},
    FormatType->InputForm,
    ShowStringCharacters->True,
    NumberMarks->True,
    CounterIncrements->"Input",
    StyleMenuListing->None,
    FontWeight->"Bold"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Output"],
    CellMargins->{{47, 10}, {7, 5}},
    CellEditDuplicate->True,
    CellGroupingRules->"OutputGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultOutputFormatType,
    AutoItalicWords->{},
    FormatType->InputForm,
    CounterIncrements->"Output"],
  
  Cell[StyleData["Output", "Presentation"],
    CellMargins->{{72, Inherited}, {10, 8}},
    LineSpacing->{1, 0}],
  
  Cell[StyleData["Output", "Condensed"],
    CellMargins->{{41, Inherited}, {3, 2}}],
  
  Cell[StyleData["Output", "Printout"],
    CellMargins->{{39, 0}, {6, 4}},
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Message"],
    CellMargins->{{45, Inherited}, {Inherited, Inherited}},
    CellGroupingRules->"OutputGrouping",
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    ShowCellLabel->False,
    CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultOutputFormatType,
    AutoItalicWords->{},
    FormatType->InputForm,
    CounterIncrements->"Message",
    StyleMenuListing->None,
    FontColor->RGBColor[0, 0, 1]],
  
  Cell[StyleData["Message", "Presentation"],
    CellMargins->{{72, Inherited}, {Inherited, Inherited}},
    LineSpacing->{1, 0}],
  
  Cell[StyleData["Message", "Condensed"],
    CellMargins->{{41, Inherited}, {Inherited, Inherited}}],
  
  Cell[StyleData["Message", "Printout"],
    CellMargins->{{39, Inherited}, {Inherited, Inherited}},
    FontSize->8,
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Print"],
    CellMargins->{{45, Inherited}, {Inherited, Inherited}},
    CellGroupingRules->"OutputGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    ShowCellLabel->False,
    CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultOutputFormatType,
    AutoItalicWords->{},
    FormatType->InputForm,
    CounterIncrements->"Print",
    StyleMenuListing->None],
  
  Cell[StyleData["Print", "Presentation"],
    CellMargins->{{72, Inherited}, {Inherited, Inherited}},
    LineSpacing->{1, 0}],
  
  Cell[StyleData["Print", "Condensed"],
    CellMargins->{{41, Inherited}, {Inherited, Inherited}}],
  
  Cell[StyleData["Print", "Printout"],
    CellMargins->{{39, Inherited}, {Inherited, Inherited}},
    FontSize->8]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Graphics"],
    CellMargins->{{4, Inherited}, {Inherited, Inherited}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    ShowCellLabel->False,
    DefaultFormatType->DefaultOutputFormatType,
    FormatType->InputForm,
    CounterIncrements->"Graphics",
    ImageMargins->{{43, Inherited}, {Inherited, 0}},
    StyleMenuListing->None],
  
  Cell[StyleData["Graphics", "Presentation"],
    ImageMargins->{{62, Inherited}, {Inherited, 0}}],
  
  Cell[StyleData["Graphics", "Condensed"],
    ImageSize->{175, 175},
    ImageMargins->{{38, Inherited}, {Inherited, 0}}],
  
  Cell[StyleData["Graphics", "Printout"],
    ImageSize->{250, 250},
    ImageMargins->{{30, Inherited}, {Inherited, 0}},
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["CellLabel"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->9,
    FontColor->RGBColor[0, 0, 1]],
  
  Cell[StyleData["CellLabel", "Presentation"],
    FontSize->12],
  
  Cell[StyleData["CellLabel", "Condensed"],
    FontSize->9],
  
  Cell[StyleData["CellLabel", "Printout"],
    FontFamily->"Courier",
    FontSize->8,
    FontSlant->"Italic",
    FontColor->GrayLevel[0]]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Formulas and Programming", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["InlineFormula"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    ScriptLevel->1,
    SingleLetterItalics->True],
  
  Cell[StyleData["InlineFormula", "Presentation"],
    CellMargins->{{24, 10}, {10, 10}},
    LineSpacing->{1, 5}],
  
  Cell[StyleData["InlineFormula", "Condensed"],
    CellMargins->{{8, 10}, {6, 6}},
    LineSpacing->{1, 1}],
  
  Cell[StyleData["InlineFormula", "Printout"],
    CellMargins->{{2, 0}, {6, 6}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DisplayFormula"],
    CellMargins->{{42, Inherited}, {Inherited, Inherited}},
    CellHorizontalScrolling->True,
    ScriptLevel->0,
    SingleLetterItalics->True,
    StyleMenuListing->None,
    UnderoverscriptBoxOptions->{LimitsPositioning->True}],
  
  Cell[StyleData["DisplayFormula", "Presentation"],
    LineSpacing->{1, 5}],
  
  Cell[StyleData["DisplayFormula", "Condensed"],
    LineSpacing->{1, 1}],
  
  Cell[StyleData["DisplayFormula", "Printout"]]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Styles for Headers and Footers", "Section"],
  
  Cell[StyleData["Header"],
    CellMargins->{{0, 0}, {4, 1}},
    StyleMenuListing->None,
    FontSize->10,
    FontSlant->"Italic"],
  
  Cell[StyleData["Footer"],
    CellMargins->{{0, 0}, {0, 4}},
    StyleMenuListing->None,
    FontSize->9,
    FontSlant->"Italic"],
  
  Cell[StyleData["PageNumber"],
    CellMargins->{{0, 0}, {4, 1}},
    StyleMenuListing->None,
    FontFamily->"Times",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Palette Styles", "Section"],
  
  Cell["\<\
The cells below define styles that define standard \
ButtonFunctions, for use in palette buttons.\
\>", "Text"],
  
  Cell[StyleData["Paste"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, After]}]&)}],
  
  Cell[StyleData["Evaluate"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, All], 
        SelectionEvaluate[ 
          FrontEnd`InputNotebook[ ], All]}]&)}],
  
  Cell[StyleData["EvaluateCell"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, All], 
        FrontEnd`SelectionMove[ 
          FrontEnd`InputNotebook[ ], All, Cell, 1], 
        FrontEnd`SelectionEvaluateCreateCell[ 
          FrontEnd`InputNotebook[ ], All]}]&)}],
  
  Cell[StyleData["CopyEvaluate"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`SelectionCreateCell[ 
          FrontEnd`InputNotebook[ ], All], 
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, All], 
        FrontEnd`SelectionEvaluate[ 
          FrontEnd`InputNotebook[ ], All]}]&)}],
  
  Cell[StyleData["CopyEvaluateCell"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`SelectionCreateCell[ 
          FrontEnd`InputNotebook[ ], All], 
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, All], 
        FrontEnd`SelectionEvaluateCreateCell[ 
          FrontEnd`InputNotebook[ ], All]}]&)}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Hyperlink Styles", "Section"],
  
  Cell["\<\
The cells below define styles useful for making hypertext \
ButtonBoxes.  The \"Hyperlink\" style is for links within the same Notebook, \
or between Notebooks.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Hyperlink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontFamily->"Helvetica",
    FontSize->12,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    FontColor->GrayLevel[1],
    FontVariations->{"Underline"->False,
    "Outline"->False,
    "Shadow"->False},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookLocate[ #2]}]&),
    Active->True,
    ButtonNote->ButtonData}],
  
  Cell[StyleData["Hyperlink", "Presentation"]],
  
  Cell[StyleData["Hyperlink", "Condensed"]],
  
  Cell[StyleData["Hyperlink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell["\<\
The following styles are for linking automatically to the on-line \
help system.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MainBookLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontFamily->"Helvetica",
    FontSize->12,
    FontWeight->"Bold",
    FontColor->GrayLevel[1],
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "MainBook", #]}]&),
    Active->True,
    ButtonFrame->"Palette",
    Background->RGBColor[0.300008, 0.603403, 0.633402]}],
  
  Cell[StyleData["MainBookLink", "Presentation"]],
  
  Cell[StyleData["MainBookLink", "Condensed"]],
  
  Cell[StyleData["MainBookLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["AddOnsLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontFamily->"Helvetica",
    FontSize->12,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    FontColor->GrayLevel[1],
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "AddOns", #]}]&),
    Active->True,
    ButtonFrame->"Palette",
    Background->RGBColor[0.300008, 0.603403, 0.633402]}],
  
  Cell[StyleData["AddOnsLink", "Presentation"]],
  
  Cell[StyleData["AddOnsLink", "Condensed"]],
  
  Cell[StyleData["AddOnLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["RefGuideLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontFamily->"Helvetica",
    FontSize->12,
    FontWeight->"Bold",
    FontColor->GrayLevel[1],
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "RefGuideLink", #]}]&),
    Active->True,
    ButtonFrame->"Palette",
    Background->RGBColor[0.300008, 0.603403, 0.633402]}],
  
  Cell[StyleData["RefGuideLink", "Presentation"]],
  
  Cell[StyleData["RefGuideLink", "Condensed"]],
  
  Cell[StyleData["RefGuideLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["GettingStartedLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontFamily->"Helvetica",
    FontSize->12,
    FontWeight->"Bold",
    FontColor->GrayLevel[1],
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "GettingStarted", #]}]&),
    Active->True,
    ButtonFrame->"Palette",
    Background->RGBColor[0.300008, 0.603403, 0.633402]}],
  
  Cell[StyleData["GettingStartedLink", "Presentation"]],
  
  Cell[StyleData["GettingStartedLink", "Condensed"]],
  
  Cell[StyleData["GettingStartedLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["OtherInformationLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontFamily->"Helvetica",
    FontSize->12,
    FontWeight->"Bold",
    FontColor->GrayLevel[1],
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "OtherInformation", #]}]&),
    Active->True,
    ButtonFrame->"Palette",
    Background->RGBColor[0.4, 0.803403, 0.633402]}],
  
  Cell[StyleData["OtherInformationLink", "Presentation"]],
  
  Cell[StyleData["OtherInformationLink", "Condensed"]],
  
  Cell[StyleData["OtherInformationLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]]
  }, Open  ]],
  
  Cell[CellGroupData[{
  
  Cell["Placeholder Styles", "Section"],
  
  Cell["\<\
The cells below define styles useful for making placeholder \
objects in palette templates.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Placeholder"],
    Editable->False,
    Selectable->False,
    StyleBoxAutoDelete->True,
    Placeholder->True,
    StyleMenuListing->None],
  
  Cell[StyleData["Placeholder", "Presentation"]],
  
  Cell[StyleData["Placeholder", "Condensed"]],
  
  Cell[StyleData["Placeholder", "Printout"]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SelectionPlaceholder"],
    Editable->False,
    Selectable->False,
    StyleBoxAutoDelete->True,
    Placeholder->Primary,
    StyleMenuListing->None,
    DrawHighlighted->True],
  
  Cell[StyleData["SelectionPlaceholder", "Presentation"]],
  
  Cell[StyleData["SelectionPlaceholder", "Condensed"]],
  
  Cell[StyleData["SelectionPlaceholder", "Printout"]]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["FormatType Styles", "Section"],
  
  Cell["\<\
The cells below define styles that are mixed in with the styles \
of most cells.  If a cell's FormatType matches the name of one of the styles \
defined below, then that style is applied between the cell's style and its \
own options.\
\>", "Text"],
  
  Cell[StyleData["CellExpression"],
    PageWidth->Infinity,
    CellMargins->{{6, Inherited}, {Inherited, Inherited}},
    ShowCellLabel->False,
    ShowSpecialCharacters->False,
    AllowInlineCells->False,
    AutoItalicWords->{},
    StyleMenuListing->None,
    FontFamily->"Courier",
    Background->GrayLevel[1]],
  
  Cell[StyleData["InputForm"],
    AllowInlineCells->False,
    StyleMenuListing->None,
    FontFamily->"Courier"],
  
  Cell[StyleData["OutputForm"],
    PageWidth->Infinity,
    TextAlignment->Left,
    LineSpacing->{1, -5},
    StyleMenuListing->None,
    FontFamily->"Courier"],
  
  Cell[StyleData["StandardForm"],
    LineSpacing->{1.25, 0},
    StyleMenuListing->None,
    FontFamily->"Courier"],
  
  Cell[StyleData["TraditionalForm"],
    LineSpacing->{1.25, 0},
    SingleLetterItalics->True,
    TraditionalFunctionNotation->True,
    DelimiterMatching->None,
    StyleMenuListing->None],
  
  Cell["\<\
The style defined below is mixed in to any cell that is in an \
inline cell within another.\
\>", "Text"],
  
  Cell[StyleData["InlineCell"],
    TextAlignment->Left,
    ScriptLevel->1,
    StyleMenuListing->None],
  
  Cell[StyleData["InlineCellEditing"],
    StyleMenuListing->None,
    Background->RGBColor[1, 0.749996, 0.8]],
  
  Cell[StyleData["ButtonBG"],
    PageWidth->400,
    ShowCellBracket->False,
    CellMargins->{{30, 180}, {0, 0}},
    CellFrameMargins->{{5, 0}, {8, 8}},
    TextAlignment->Center,
    FrameBoxOptions->{BoxMargins->{{0.4, 0.4}, {0.5, 0.5}}},
    GridBoxOptions->{RowSpacings->0.25,
    ColumnWidths->15,
    RowMinHeight->1.9,
    RowsEqual->False,
    ColumnsEqual->True}]
  }, Open  ]]
  }, Open  ]]
  }]
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "formula"->{
    Cell[10342, 335, 63, 1, 70, "Subsubsection",
      CellTags->"formula"]},
  "2DGraphics"->{
    Cell[11986, 391, 62, 1, 70, "Subsubsection",
      CellTags->"2DGraphics"]},
  "3DGraphics"->{
    Cell[13321, 438, 62, 1, 70, "Subsubsection",
      CellTags->"3DGraphics"]},
  "Diagrams"->{
    Cell[14471, 479, 69, 1, 70, "Subsubsection",
      CellTags->"Diagrams"]},
  "ArtImages"->{
    Cell[15504, 517, 60, 1, 70, "Subsubsection",
      CellTags->"ArtImages"]},
  "Animations"->{
    Cell[16102, 540, 61, 1, 70, "Subsubsection",
      CellTags->"Animations"]},
  "ColorCharts"->{
    Cell[16879, 569, 64, 1, 70, "Subsubsection",
      CellTags->"ColorCharts"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"formula", 43325, 1529},
  {"2DGraphics", 43421, 1532},
  {"3DGraphics", 43520, 1535},
  {"Diagrams", 43617, 1538},
  {"ArtImages", 43713, 1541},
  {"Animations", 43811, 1544},
  {"ColorCharts", 43911, 1547}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1732, 51, 150, 6, 81, "Subsection"],
Cell[1885, 59, 220, 6, 51, "SmallText"],
Cell[2108, 67, 538, 18, 66, "SmallText"],
Cell[2649, 87, 173, 6, 36, "SmallText"],
Cell[2825, 95, 257, 7, 66, "SmallText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3119, 107, 31, 0, 46, "Section"],
Cell[3153, 109, 1333, 33, 70, "ButtonBG"]
}, Closed]],

Cell[CellGroupData[{
Cell[4523, 147, 104, 5, 70, "Section"],
Cell[4630, 154, 2960, 91, 70, "ButtonBG"]
}, Closed]],

Cell[CellGroupData[{
Cell[7627, 250, 24, 0, 70, "Section"],
Cell[7654, 252, 2598, 74, 70, "ButtonBG"]
}, Closed]],

Cell[CellGroupData[{
Cell[10289, 331, 28, 0, 70, "Section"],

Cell[CellGroupData[{
Cell[10342, 335, 63, 1, 70, "Subsubsection",
  CellTags->"formula"],
Cell[10408, 338, 1541, 48, 70, "ButtonBG"]
}, Closed]],

Cell[CellGroupData[{
Cell[11986, 391, 62, 1, 70, "Subsubsection",
  CellTags->"2DGraphics"],
Cell[12051, 394, 1233, 39, 70, "ButtonBG"]
}, Closed]],

Cell[CellGroupData[{
Cell[13321, 438, 62, 1, 70, "Subsubsection",
  CellTags->"3DGraphics"],
Cell[13386, 441, 1048, 33, 70, "ButtonBG"]
}, Closed]],

Cell[CellGroupData[{
Cell[14471, 479, 69, 1, 70, "Subsubsection",
  CellTags->"Diagrams"],
Cell[14543, 482, 924, 30, 70, "ButtonBG"]
}, Closed]],

Cell[CellGroupData[{
Cell[15504, 517, 60, 1, 70, "Subsubsection",
  CellTags->"ArtImages"],
Cell[15567, 520, 498, 15, 70, "ButtonBG"]
}, Closed]],

Cell[CellGroupData[{
Cell[16102, 540, 61, 1, 70, "Subsubsection",
  CellTags->"Animations"],
Cell[16166, 543, 676, 21, 70, "ButtonBG"]
}, Closed]],

Cell[CellGroupData[{
Cell[16879, 569, 64, 1, 70, "Subsubsection",
  CellTags->"ColorCharts"],
Cell[16946, 572, 658, 21, 70, "ButtonBG"]
}, Closed]],

Cell[CellGroupData[{
Cell[17641, 598, 38, 0, 70, "Subsubsection"],
Cell[17682, 600, 219, 5, 70, "ButtonBG"]
}, Closed]]
}, Closed]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

